#ifndef _TRIMESH_H
#define _TRIMESH_H

#include "Vector.h"
#include "objloader.h"
#include "glutil.h"

class Trimesh
{
public:
	Trimesh(const ObjLoader&, bool selfAO);
	~Trimesh();

	void render();
	void renderDepth();
	void subdivide(float len);

//private:
	struct Vertex
	{
		m::Vector3 p;
		m::Vector3 n;
		m::Vector4 c;
		m::Vector2 t;
		float ao;

		inline Vertex average(const Vertex& b)
		{
			Vertex v;
			v.p = (p + b.p) / 2.0f;
			v.n = (n + b.n) / 2.0f;
			v.c = (c + b.c) / 2.0f;
			v.t = (t + b.t) / 2.0f;
			v.ao = (ao + b.ao) / 2.0f;
			return v;
		}
	};

	struct Triangle
	{
	public:
		int v[3];
		GLuint tex;
	};

	void updateBuffers();

	m::Vector3 position;
	m::Vector3 rotation;

//private:
	std::vector<Vertex> vertices;
	std::vector<Triangle> triangles;
	int list, list2;

	GLuint vbuf;
	GLuint ebuf;
	GLuint vbuf2;

	std::vector<std::pair<int, int> > chunks;
};

#endif
