#ifndef _OBJLOADER_H
#define _OBJLOADER_H

#include "Vector.h"
#include <vector>
#include <string>

class ObjLoader
{
public:
	struct VertexIndices
	{
		int v;
		int t;
		int n;
	};

	struct Material
	{
		Material()
		{
			illum = 0;
			ambient[0] = ambient[1] = ambient[2] = 0.0f;
			diffuse[0] = diffuse[1] = diffuse[2] = 0.8f;
			specular[0] = specular[1] = specular[2] = 0.0f;
			emission[0] = emission[1] = emission[2] = 0.0f;
		}

		std::string name;
		int illum;
		float ambient[3];
		std::string ambientMap;
		float diffuse[3];
		std::string diffuseMap;
		float specular[3];
		std::string specularMap;
		float emission[3];
		std::string emissionMap;
		float shininess;
		float d; // What's this? Opacity?
	};

	class Polygon
	{
	public:
		int material;
		std::vector<VertexIndices> vertices;
	};

	ObjLoader(const char* filename, float scale = 1.0f);
	ObjLoader(const char* filename, const m::Vector3& s);
	~ObjLoader();

	void translate(float x, float y, float z)
	{
		for (unsigned int i = 0; i < vertices.size(); i++)
		{
			vertices[i].x += x;
			vertices[i].y += y;
			vertices[i].z += z;
		}
	}

	void swapYZ()
	{
		for (unsigned int i = 0; i < vertices.size(); i++)
			std::swap(vertices[i].y, vertices[i].z);

		for (unsigned int i = 0; i < normals.size(); i++)
			std::swap(normals[i].y, normals[i].z);

		for (unsigned int i = 0; i < polygons.size(); i++)
			polygons[i].vertices = std::vector<VertexIndices>(polygons[i].vertices.rbegin(), polygons[i].vertices.rend());
	}

	void negateXZ()
	{
		for (unsigned int i = 0; i < vertices.size(); i++)
		{
			vertices[i].x *= -1.0f;
			vertices[i].z *= -1.0f;
		}

		for (unsigned int i = 0; i < normals.size(); i++)
		{
			normals[i].x *= -1.0f;
			normals[i].z *= -1.0f;
		}
	}

public:
	std::vector<m::Vector3> vertices;
	std::vector<m::Vector3> normals;
	std::vector<m::Vector3> textureCoords;
	std::vector<Polygon> polygons;
	std::vector<Material> materials;

private:
	void load(const char* filename);
	void loadMtl(const char* filename);
	void scale(const m::Vector3& s);
};

#endif
