#ifndef _TIMING_H
#define _TIMING_H

#include "Timer.h"
#include <assert.h>
#include <string.h>

extern sys::Timer timer;
extern int timer_individuals;
extern double prevTime;

class AverageTiming
{
public:
	AverageTiming() : n(0) {}
	~AverageTiming() {}

	void insert(double t)
	{
		assert(n <= 1000 && t >= 0.0);

		memmove(last+1, last, ((n >= 1000) ? 999 : n) * sizeof(double));
		last[0] = t;

		if (n < 1000)
			n++;
	}

	double getAverage()
	{
		if (!n)
			return 0.0;

		double avg = 0.0;
		for (int i = 0; i < n; i++)
			avg += last[i];

		return avg / n;
	}

private:
	double last[1000];
	int n;
};

#define REPORT_TIME(x)\
{\
	if (timer_individuals)\
	{\
		glFlush(); glFinish();\
		static AverageTiming at;\
		double t = timer.time();\
		at.insert(t - prevTime);\
		printf("%24s %.1f ms   %.1f ms              \n", x, (t - prevTime) * 1000.0, at.getAverage() * 1000.0);\
		prevTime = timer.time();\
	}\
}

#endif
