#include "textures.h"

Textures textures;

Textures::Textures()
{
}

Textures::~Textures()
{
}

struct Textures::Texture& Textures::load(const std::string& s)
{
	if (textures.find(s) != textures.end())
		return textures[s];

	if (s != "")
		printf("Loading texture 'data/%s' (.raw)\n", s.c_str());

	Texture texture;
	texture.average = m::Vector3(0, 0, 0);

	assert(glGetError() == GL_NO_ERROR);
	glGenTextures(1, &texture.id);
	glBindTexture(GL_TEXTURE_2D, texture.id);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);

	FILE* fp = fopen(("data/" + s + ".raw").c_str(), "rb");
	if (!fp)
	{
		printf("FAILED!\n");

		unsigned char white[8*8*3];
		memset(white, 255, sizeof(white));

		assert(glGetError() == GL_NO_ERROR);
		gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, 8, 8, GL_RGB, GL_UNSIGNED_BYTE, white);
		assert(glGetError() == GL_NO_ERROR);

		texture.average = m::Vector3(1, 1, 1);

		textures[s] = texture;
		return textures[s];
	}

	unsigned int w, h;
	w = fgetc(fp) * 256;
	w += fgetc(fp);
	h = fgetc(fp) * 256;
	h += fgetc(fp);

	printf("%d %d\n", w, h);
	fflush(NULL);

	unsigned char* data = new unsigned char [w * h * 3];

	for (unsigned int i = 0; i < h; i++)
	{
		for (unsigned int j = 0; j < w; j++)
		{
			unsigned char r = fgetc(fp);
			unsigned char g = fgetc(fp);
			unsigned char b = fgetc(fp);

			data[(i * w + j) * 3 + 0] = r;
			data[(i * w + j) * 3 + 1] = g;
			data[(i * w + j) * 3 + 2] = b;

			texture.average += m::Vector3(r, g, b);
		}
	}

	texture.average *= 1.0f / (w * h * 255.0f);

	gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, w, h, GL_RGB, GL_UNSIGNED_BYTE, data);

	assert(glGetError() == GL_NO_ERROR);

	delete [] data;

	fclose(fp);

	textures[s] = texture;
	return textures[s];
}
