#ifndef _KDTREE_H
#define _KDTREE_H

#include "Vector.h"
#include <vector>
#ifdef WIN32
typedef unsigned int uint32_t;
#else
#include <stdint.h>
#endif

class KDTree
{
public:
	KDTree();
	~KDTree();

	int feedTriangles(const std::vector<m::Vector3>& vertices, int* triangles, int n);

	void update();

	int intersect(const m::Vector3& p, const m::Vector3& d, float& t, float& u, float& v) const;
	bool shadowIntersect(const m::Vector3& p, const m::Vector3& d, float maxT) const;

	inline size_t getTriangleCount() const { return triangles.size(); }

public:
	struct Node
	{
		uint32_t dir;
		float pos;
		uint32_t right;
	};

private:
	struct Triangle
	{
		uint32_t a, b, c;
	};

private:
	int newNode();
	int build(int* tris, int n, const m::Vector3& min, const m::Vector3& max);
	void allocateBuckets(int n);

private:
	unsigned int totalNodes;
	Node* nodes;

	m::Vector3 sceneMin;
	m::Vector3 sceneMax;

	std::vector<m::Vector3> vertices;
	std::vector<Triangle> triangles;

	int* triangleBuckets;
	int triangleBucketsCount;
	int triangleBucketsSize;

	std::vector<std::pair<m::Vector3, m::Vector3> > bboxes;
};

#endif
