#ifndef _GL_UTIL_
#define _GL_UTIL_

#include <GL/glew.h>
#if 0
#  ifdef _MSC_VER
#    include <windows.h>
#  endif
#  include <GL/gl.h>
#  include <GL/glu.h>
#endif
#ifdef __APPLE__
#  include <OpenGL/gl.h>
#  include <OpenGL/glu.h>
#endif
#include <string>

#ifdef min
#  undef min
#  undef max
#endif

#include "Vector.h"

void setUniform(GLuint program, const std::string& name, const m::Vector3& value);
void setUniform(GLuint program, const std::string& name, float value);
void setUniform(GLuint program, const std::string& name, unsigned int value);
void setUniform4x4Mat(GLuint program, const std::string& name, const double *value);
void setUniform4x4Mat(GLuint program, const std::string& name, const float *value);

#define MAKE_GLSL_PROGRAM(f, n) makeGLSLProgram(f, n, #f, #n)
GLuint makeGLSLProgram(const char* fragSrc, const char* vtxSrc, const char* fname, const char* vname);

void makeDepthBufferObject(GLuint& shadowMapFB, GLuint& shadowTexId, int shadowMapSize);

#define CHECK_FRAMEBUFFER_STATUS()                            \
    {                                                           \
    GLenum status;                                            \
    status = glCheckFramebufferStatusEXT(GL_FRAMEBUFFER_EXT); \
    switch(status) {                                          \
        case GL_FRAMEBUFFER_COMPLETE_EXT:                       \
        break;                                                \
        case GL_FRAMEBUFFER_UNSUPPORTED_EXT:                    \
        /* choose different formats */                        \
        break;                                                \
        default:                                                \
        /* programming error; will fail on all hardware */    \
        assert(0);                                            \
	} \
    }

void accFrustum(GLdouble left, GLdouble right, GLdouble bottom, 
   GLdouble top, GLdouble near, GLdouble far, GLdouble pixdx, 
   GLdouble pixdy, GLdouble eyedx, GLdouble eyedy, GLdouble focus);

void accPerspective(GLdouble fovy, GLdouble aspect, 
   GLdouble near, GLdouble far, GLdouble pixdx, GLdouble pixdy, 
   GLdouble eyedx, GLdouble eyedy, GLdouble focus);

static inline void lookat(const m::Vector3& pos, const m::Vector3& dir)
{
	if (fabs(dir.y) < 0.5f)
	{
		gluLookAt(
				pos.x, pos.y, pos.z,
				pos.x+dir.x, pos.y+dir.y, pos.z+dir.z,
				0, 1, 0);
	}
	else
	{
		gluLookAt(
				pos.x, pos.y, pos.z,
				pos.x+dir.x, pos.y+dir.y, pos.z+dir.z,
				1, 0, 0);
	}
}

#endif // _GL_UTIL_

