#ifndef _DEFERRED_H
#define _DEFERRED_H

#include "glutil.h"
#include "configuration.h"

#define STR2(x) #x
#define STR(x) STR2(x)

class Deferred
{
public:
	Deferred();
	~Deferred();

	void renderScene(void (*render)(void*), void*);

	void do_mosaic();

	void prepare(GLuint program);
	void done();

public:
	struct GBuffer
	{
		GBuffer() : fb(0), rb(0) { tex[0] = tex[1] = 0; }
		/* TODO: destructor */
		void init(int width, int height);
		void bindToProgram(GLuint program);

		GLuint fb;
		GLuint rb;
		GLuint tex[3];
	};

	struct CBuffer
	{
		CBuffer() : fb(0) { tex = 0; }
		/* TODO: destructor */
		void init(int width, int height);

		GLuint fb;
		GLuint tex;
	};

	void renderQuad();
	void mosaic(GBuffer& g1, GBuffer& g2);
	void demosaic(GBuffer& g1, GBuffer& g2);

public:
	// Initial geometry buffer
	GBuffer g1;
	// Splitted geometry buffer
	GBuffer g2;
	// Rendered color buffer for splitted geometry buffer
	CBuffer c1;
	// Combined color buffer
	CBuffer c2;
	// Color buffer for direct lighting
	CBuffer c3;
};

#endif
