#ifndef _CONFIGURATION_H
#define _CONFIGURATION_H

#include <map>
#include <string>

class Configuration
{
public:
	Configuration();
	~Configuration();

	bool load(const char* fn);
	bool parseLine(const char* l);

	void setInt(const char* n, int v);
	void setFloat(const char* n, double v);
	void setString(const char* n, const char* v);

	int getInt(const char* n) const;
	double getFloat(const char* n) const;
	const char* getString(const char* n) const;

private:
	enum ValueType
	{
		INTEGER = 0,
		FLOAT = 1,
		STRING = 2
	};

	struct Value
	{
		ValueType type;
		int i;
		double f;
		std::string s;
	};

private:
	std::map<std::string, Value> values;
};

extern Configuration config;

#define CONFI(s) config.getInt(#s)
#define CONFF(s) config.getFloat(#s)
#define CONFS(s) config.getString(#s)

#endif
