#ifndef _PARABOLOIDMAP_H
#define _PARABOLOIDMAP_H

#include "glutil.h"
#include "Vector.h"

class ParaboloidMap
{
public:
	ParaboloidMap(int size);
	~ParaboloidMap();

	void render(void (*render)(void*), void*);
	void prepareRendering();
	void doneRendering();

	void getMatrix(float* m);

	void setPosition(const m::Vector3& v);
	void setDirection(const m::Vector3& v);

private:
	void updateMatrix();

public:
	m::Vector3 pos;
	m::Vector3 dir;

	float transform[16];

//private:
	int size;
	int offsetX;
	int offsetY;
	GLuint texture;
	GLuint fb;
	GLint viewport[4];
};

#endif
