#ifndef _LIGHT_H
#define _LIGHT_H

#include "Vector.h"
#include "cubemap.h"
#include "paraboloidmap.h"
#include "configuration.h"
#include <vector>
#include <CGAL/Exact_predicates_inexact_constructions_kernel.h>
#include <CGAL/Delaunay_triangulation_2.h>
#include <CGAL/Triangulation_vertex_base_with_info_2.h>
#include <CGAL/Delaunay_triangulation_3.h>
#include <CGAL/Triangulation_hierarchy_3.h>
#include <CGAL/Triangulation_vertex_base_with_info_3.h>
#include <CGAL/Triangulation_hierarchy_vertex_base_3.h>

typedef CGAL::Filtered_kernel< CGAL::Simple_cartesian<float> > 			K;
//typedef CGAL::Simple_cartesian<double>						 			K;

typedef CGAL::Triangulation_vertex_base_with_info_2<int, K>  			Vb2;
typedef CGAL::Triangulation_data_structure_2<Vb2>						Tds2; 
typedef CGAL::Delaunay_triangulation_2<K,Tds2>							Triangulation2;

typedef CGAL::Triangulation_vertex_base_3<K>							Vb3;
typedef CGAL::Triangulation_hierarchy_vertex_base_3<Vb3>				Vbh3;
typedef CGAL::Triangulation_data_structure_3<Vbh3>						Tds3;
typedef CGAL::Delaunay_triangulation_3<K,Tds3>							Dt3;
typedef CGAL::Triangulation_hierarchy_3<Dt3>							Triangulation3;

class Light
{
public:
	enum Type
	{
		SPOT,
		OMNI
	};

	Light(int totalSubLights);
	~Light();

	void setPosition(const m::Vector3& p);
	void setDirection(const m::Vector3& d);
	void setIntensity(const m::Vector3& i);

	void renderPrimaryShadowMap(void (*render)(void*), void* user);
	void updateSecondaryLights(class RayTracer* rt, void (*srender)(void*), void* suser, bool initial);

	void outputPS();

private:
	void updateDelaunay();
	void updateVoronoi();
	void updateDispersion();

	void cullUnseenLights(class RayTracer* rt);

public:
	struct SubLight
	{
		inline SubLight() : shadowMap(CONFI(secondary_shadowmap_size)) {}
		inline ~SubLight() {}

		bool valid;
		bool newValid;
		m::Vector3 position;
		m::Vector3 direction;
		m::Vector3 nonWeightedIntensity;
		m::Vector3 intensity;
		ParaboloidMap shadowMap;

		m::Vector3 p;
		float area;
	};

public:
	CubeMap shadowMap;

	Type type;

	m::Vector3 position;
	m::Vector3 direction;
	m::Vector3 intensity;

	m::Vector3 right;
	m::Vector3 up;

	Triangulation2 tri2;
	Triangulation3 tri3;

	int subLightCount;
	SubLight* subLights;

public:
	struct VoronoiEdge2
	{
		int v[2];
		m::Vector2 p[2];
	};
	std::vector<VoronoiEdge2> edges2;

	std::map<Triangulation2::Vertex_handle, int> indices2;
	std::map<Triangulation3::Vertex_handle, int> indices3;

	float disp;
	m::Vector3 dispP;

	struct DebugTri2
	{
		DebugTri2(m::Vector2 a, m::Vector2 b, m::Vector2 c, float r, float g, float b_)
			: r(r), g(g), b(b_)
		{
			p[0] = a;
			p[1] = b;
			p[2] = c;
		}
		m::Vector2 p[3];
		float r, g, b;
	};
	std::vector<DebugTri2> debugTris2;

	struct DebugTri3
	{
		DebugTri3(m::Vector3 a, m::Vector3 b, m::Vector3 c, float r, float g, float b_)
			: r(r), g(g), b(b_)
		{
			p[0] = a;
			p[1] = b;
			p[2] = c;
		}

		m::Vector3 p[3];
		float r, g, b;
	};
	std::vector<DebugTri3> debugTris3;

	struct VoronoiEdge3
	{
		int v[2];
		m::Vector3 p[2];
	};
	std::vector<std::pair<m::Vector3, m::Vector3> > debugVoronoiEdges3;

	std::vector<m::Vector3> debugVoronoiVertices3;
};

#endif
