#ifndef _delaunayutils_h
#define _delaunayutils_h

static inline bool circle_through_three_points(const Vector2 &a, const Vector2 &b, const Vector2 &c, Vector2 &p, float &r)
{
	float tmp = a.y * (b.x - c.x) + b.y * c.x - b.x * c.y + a.x * (-b.y + c.y);

	if (tmp == 0.0f)
		return false;

	float rr = sqrt(
			(((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y)) *
			 ((a.x - c.x) * (a.x - c.x) + (a.y - c.y) * (a.y - c.y)) *
			 ((b.x - c.x) * (b.x - c.x) + (b.y - c.y) * (b.y - c.y))
			 / (tmp * tmp))) / 2.0f;

	tmp *= 2.0f;

	float px =
		(b.y * c.x * c.x +
		 -(b.x * b.x + b.y * b.y) * c.y +
		 b.y * c.y * c.y +
		 a.x * a.x * (-b.y + c.y) +
		 a.y * a.y * (-b.y + c.y) +
		 a.y * (b.x * b.x + b.y * b.y - c.x * c.x - c.y * c.y)) / tmp;

	float py =
		(a.x * a.x * (b.x - c.x) +
		 a.y * a.y * (b.x - c.x) +
		 c.x * (b.x * b.x + b.y * b.y - b.x * c.x) +
		 -b.x * c.y * c.y +
		 a.x * (-b.x * b.x - b.y * b.y + c.x * c.x + c.y * c.y)) / tmp;

	r = rr;
	p.x = px;
	p.y = py;

	return true;
}

static inline double area_of_segment(double r, double d)
{
	assert(d >= 0.0);

	if (d + 0.00001 > r)
		return 0.00001;
	else if (d < 0.00001)
		return 3.14159265 * r * r / 2.0;
	else
		return r * r * acos(d / r) - d * sqrt(r*r - d*d);
}

static inline double center_of_segment(double r, double d)
{
	return 2.0 * (-d + r) * (d + r) * sqrt(r*r - d*d) / 3.0 / area_of_segment(r, d);
}

#endif
