/*************************************************************************
 *
 * EVERT Library
 * -------------
 *
 * (C) 2004-2005 Samuli Laine
 * All Rights Reserved.
 *
 ************************************************************************/

#include "../interface/elTimer.hpp"

#include <windows.h>
#include <gl/glu.h>

using namespace EL;

//------------------------------------------------------------------------

Timer::Timer(void)
{
	clear();
}

void Timer::clear(void)
{
	LARGE_INTEGER li;
	QueryPerformanceCounter(&li);
	m_timer = li.QuadPart;
}

double Timer::get(void) const
{
	LARGE_INTEGER li;
	LARGE_INTEGER freq;
	QueryPerformanceCounter(&li);
	li.QuadPart -= m_timer;
	QueryPerformanceFrequency(&freq);
	return (double)li.QuadPart / (double)freq.QuadPart;
}

//------------------------------------------------------------------------

double CPUTimer::s_msec = 1.0;

__declspec(naked) __int64 CPUTimer::rdtsc(void)
{
	__asm
	{
		rdtsc
		ret
	}
}

void CPUTimer::calibrate(const Timer& referenceTimer)
{
	double  t1 = referenceTimer.get();
	__int64 t2 = getI();
	s_msec = t1/(double)t2;
}
