%EQF_INTEGRAND  Evalute integrand for EQ input coefficient
%
% Syntax:
%   f = eqf_integrand(t,a1,a2,b1,b2,w0,T,j,n)
%
% In:
%   t  - Time
%   a1 - Numerator coeffient
%   a2 - Numerator coeffient
%   b1 - Denominator coeffient
%   b2 - Denominator coeffient
%   w0 - Angular velocity
%   T  - Sampling period
%
% Out:
%   f = expm(F*(T-t))*L*sinc((t+j*T)/T)*hamming((t+j*T)/T,n)
%
% Description:
%   Evalute integrand for EQ input coefficient B_j

function f = eqf_integrand(t,a1,a2,b1,b2,w0,T,j,n)

   L = w0*[b1;b2];
   f = eqf_expm(a1,a2,w0,T-t)*L*sinc((t+j*T)/T)...
          *(0.54+0.46*cos(pi*(t+j*T)/(n*T)));
