%%
%% This is the file 'njsr.cls' intended for formatting submissions to
%% the journals 'Nordic Journal of Surveying and Real Estate Research',
%% and 'Maanmittaus'.
%%
%% Your class definition should be 
%%
%%     \documentclass{njsr} for NJSR.
%%     \documentclass[special]{njsr} for NJSR Special Series.
%%     \documentclass[finnish]{njsr}  for mm.
%%     \documentclass[esitelma]{njsr} for a presentation at the
%%          Maanmittaustieteiden Pivt or other A4 format 
%%          Proceedings type collection.
%%
%% Note that for producing PDF, you should first produce DVI, then
%% PostScript, and then convert to PDF using ps2pdf.
%%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{njsr}
          [2006/08/25 v0.3 Maanmittaustieteiden Seuran formaatit]
% Options:
\newif\if@njsr\@njsrtrue
\newif\if@swed\@swedfalse
\DeclareOption{njsr}{\@njsrtrue}
\DeclareOption{finnish}{\@njsrfalse}
\DeclareOption{swedish}{\@njsrfalse\@swedtrue}
\newif\if@esi\@esifalse
\DeclareOption{esitelma}{\@njsrfalse\@esitrue}
\newif\if@spec\@specfalse
\DeclareOption{special}{\@njsrtrue\@spectrue}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax
%
\if@esi
  \if@swed
      \LoadClass[swedish,twoside,12pt,a4paper]{article}
    \else
      \LoadClass[finnish,twoside,12pt,a4paper]{article}
    \fi
\else
  \if@njsr
	\LoadClass[twoside,11pt]{article}
  \else
    \if@swed
      \LoadClass[swedish,twoside,11pt]{article}
    \else
      \LoadClass[finnish,twoside,11pt]{article}
    \fi
  \fi
\fi
\RequirePackage{mathptmx}
\RequirePackage{times}
\RequirePackage{lastpage}
\RequirePackage{apalike}

\def\thebibliography#1{\section*{\refname}\vspace{6pt}\list
  {\relax}{\setlength{\labelsep}{0em}
  \setlength{\itemindent}{-15pt}
  \setlength{\leftmargin}{15pt}
  \setlength{\parsep}{1pt plus 1pt}
  \setlength{\itemsep}{4pt plus 1pt}
  }%
%    \sloppy\clubpenalty4000\widowpenalty4000
%    \sfcode`\.=1000\relaxi
}%


% Redefine \maketitle:
\renewcommand\maketitle{\par
 \begingroup
   \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
   \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
   \long\def\@makefntext##1{\parindent 1em\noindent
           \hb@xt@1.8em{%
               \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
   \if@twocolumn
     \ifnum \col@number=\@ne
       \@maketitle
     \else
       \twocolumn[\@maketitle]%
     \fi
   \else
     \newpage
     \global\@topnum\z@   % Prevents figures from going at top of page.
     \@maketitle
   \fi
 \@thanks
 \endgroup
 \setcounter{footnote}{0}%
 \global\let\thanks\relax
 \global\let\maketitle\relax
 \global\let\@maketitle\relax
 \global\let\@thanks\@empty
 \global\let\@author\@empty
 \global\let\@date\@empty
 \global\let\@title\@empty
 \global\let\title\relax
 \global\let\author\relax
 \global\let\date\relax
 \global\let\and\relax
% Added 12.11.2005; does this work?
% Apparently not -- MV 3.2.2006
%% \global\let\@issue\@empty
%% \global\let\@pubyear\@empty
%% \global\let\@volume\@empty
%% \global\let\@shorttitle\@empty
%% \global\let\@journal\@empty
%% \global\let\@longjournal\@empty
}
%
\def\@maketitle{%
 \newpage
 \if@esi
   \itshape\ \vskip 1cm%
 \else
   \itshape\@longjournal
 \fi%
   \vskip 1.0cm%
 \let \footnote \thanks
   {%\if@esi\else\hrule\par\fi
   \par\normalfont\Large\bfseries%
   \if@esi
     \raggedright%
   \else
     \centering%
   \fi
   \@title\par}%
   \vbox {
   \vskip 1.0cm
%%   \if@esi\raggedright\fi%
   \if@esi\centering\else\centering\fi%
   \normalfont\normalsize\@author%
   }\vskip 0.5cm plus 0.5cm}%
% Redefine \section and \subsection:
\renewcommand\section{\@startsection {section}{1}{\z@}%
                                  {-2.5ex \@plus -0.2ex \@minus -.2ex}%
                                  {0.1ex \@plus .1ex}%
   {\normalfont\raggedright\bfseries\rmfamily}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                    {-2.5ex\@plus -0.2ex \@minus -.2ex}%
                                    {0.1ex \@plus .1ex}%
   {\normalfont\raggedright\bfseries\itshape\rmfamily}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                    {-2.5ex\@plus -0.2ex \@minus -.2ex}%
                                    {0.1ex \@plus .1ex}%
   {\normalfont\raggedright\itshape\rmfamily}}
% Redefine section, subsection numbering:
\renewcommand \thesection {\@arabic\c@section}
\renewcommand\thesubsection{\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection.\@arabic\c@subsubsection}
% Define the header and footer lines:
\if@esi
\def\ps@myheadings{%
   \def\@oddfoot{\@empty}
   \def\@evenfoot{\@empty}
   \def\@evenhead{%
     \normalfont\thepage\hfil%
      \itshape\@shorttitle}%
   \def\@oddhead{%
     \itshape\@journal \@volume\ (\@pubyear)%
      \hfil\normalfont\thepage}%
   \let\@mkboth\@gobbletwo
   \let\sectionmark\@gobble
   \let\subsectionmark\@gobble
}%
\else
\def\ps@myheadings{%
   \def\@oddfoot{\@empty}
   \def\@evenfoot{\@empty}
   \def\@oddhead{\itshape\small\@journal\hfil Volume\,\@volume,\, Number \@issue, \@pubyear%
      \hskip-\hsize\rule[-5pt]{\hsize}{0.4pt}%
      }%
   \def\@evenhead{\itshape\small\thepage\hfil\@shorttitle%
      \hskip-\hsize\rule[-5pt]{\hsize}{0.4pt}%
      }%
   \let\@mkboth\@gobbletwo
   \let\sectionmark\@gobble
   \let\subsectionmark\@gobble
}%
\fi

% Define the elements used in header/footer:
\newcommand{\shorttitle}[1]{\def\@shorttitle{#1}}
\if@njsr
  \newcommand{\volume}[1]{\def\@volume{#1}}
\else
  \if@esi
    \newcommand{\volume}[1]{\def\@volume{#1}}
  \else
    \newcommand{\volume}[1]{\def\@volume{}}%
  \fi
\fi
\newcommand{\issue}[1]{\def\@issue{#1}}
\newcommand{\pubyear}[1]{\def\@pubyear{#1}}
\newcommand{\received}[1]{\def\@received{#1}}
\if@njsr
  \if@spec
    \newcommand{\@journal}{Nordic Journal of Surveying and Real Estate Research -- Special Series}%
  \else
    \newcommand{\@journal}{Nordic Journal of Surveying and Real Estate Research}%
  \fi
\else
  \if@esi
    \newcommand{\@journal}{Maanmittaustieteiden Seuran julkaisu\,}
  \else
    \newcommand{\@journal}{Maanmittaus}
  \fi
\fi
\newcommand{\@longjournal}{%
\if@njsr
  \raggedleft\small\@journal\ \@volume:\@issue\ (\@pubyear) \thepage --%
\pageref{LastPage} \\ \@received%
\else
  \if@esi
    \@journal\ nro\ \@issue\ (\@pubyear)%
    \ s.\ \thepage--\pageref{LastPage}
  \else
    \@journal\ nro\ \@issue,\ \@pubyear%
    \ s.\ \thepage--\pageref{LastPage}
  \fi
\fi
}%
%
\newcommand{\journal}[1]{\def\@journal{#1}}
\newcommand{\longjournal}[1]{\def\@longjournal{#1}}
  % Redefine default font etc.:
\long\def\@makecaption#1#2{%
 \vskip\abovecaptionskip
 \small
 \sbox\@tempboxa{\itshape{\textbf{#1.}} \itshape{#2}}%
 \ifdim \wd\@tempboxa >\hsize
   \itshape{\textbf{#1.}} \itshape{#2}\par
 \else
   \global \@minipagefalse
   \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
 \fi
 \vskip\belowcaptionskip
}%
%
\if@njsr\def\acknowsname{Acknowledgements}\else
  \if@swed
    \def\acknowsname{Tack}
  \else
    \def\acknowsname{Kiitokset}
  \fi%
\fi%
\if@njsr\def\keywordsname{Key words}\else
  \if@swed
    \def\keywordsname{Nyckelord}
  \else
    \def\keywordsname{Avainsanat}
  \fi
\fi%
\newcommand*\acknowslabel[1]{\normalfont\small\bfseries\acknowsname.\quad}%
\newenvironment{acknowledgements}{%
  \list{}{\labelsep\z@%
          \labelwidth\z@%
          \itemindent\z@%
	  \leftmargin\z@%
          \let\makelabel\acknowslabel}%
	  \item\relax
	  \small}%
	 {\endlist}%
\newcommand*\abstractlabel[1]{\normalfont\small\bfseries\itshape\abstractname.\hspace{0.2cm}}%
\newcommand*\keywordslabel[1]{\normalfont\small\bfseries\itshape\keywordsname.\hspace{0.2cm}}%
\renewenvironment{abstract}{%
  \list{}{\topsep\z@%
          \labelsep\z@%
          \labelwidth\z@%
          \itemindent\z@%
	  \rightmargin\leftmargin%
          \let\makelabel\abstractlabel}%
	  \item\relax
	  \small\itshape}%
	 {\endlist}%
%
\newenvironment{keywords}{%
  \list{}{\topsep\z@%
          \labelsep\z@%
          \labelwidth\z@%
          \itemindent\z@%
	  \rightmargin\leftmargin%
          \let\makelabel\keywordslabel}%
	  \item\relax
	  \small\itshape}%
	 {\endlist}%
%
\renewcommand\labelitemi[0]{\normalfont\bfseries{--}}
\renewcommand\labelitemii[0]{\normalfont{-}}
\renewcommand\labelitemiii[0]{\(\cdot\)}
\renewcommand\labelitemiv[0]{\cdot}
%
\renewcommand{\topfraction}{.9}
\renewcommand{\bottomfraction}{.9}
\renewcommand{\textfraction}{.1}
\pagestyle{myheadings}
\thispagestyle{myheadings}
\input{fleqn.clo}
\if@esi
  \setlength{\paperheight}{29.5cm}
  \setlength{\paperwidth}{21.0cm}
  \setlength{\textheight}{24.0cm}
  \setlength{\textwidth}{16.0cm}
  \setlength{\topmargin}{-0.5cm}
  \setlength{\oddsidemargin}{-0.3cm}
  \setlength{\evensidemargin}{-0.3cm}
  \setlength{\hoffset}{0.0cm}
\else
  \setlength{\paperheight}{25cm}
  \setlength{\paperwidth}{17cm}
  \setlength{\textheight}{20.3cm}
  \setlength{\textwidth}{12.6cm}
  \setlength{\oddsidemargin}{-0.3cm}
  \setlength{\evensidemargin}{-0.3cm}
  \setlength{\footskip}{0.0cm}
  \setlength{\hoffset}{0.0cm}
  \setlength{\voffset}{-1.3cm}
  \setlength{\headsep}{1.0cm}
\fi
%
\setlength\parskip{0.0pt}
\setlength\parindent{0.8cm}
\@twocolumnfalse
\flushbottom
%
\endinput
%%
%% End of file `njsr.cls'.
