#ifndef GRAPH_H
#define GRAPH_H
#include"net.H"
#include"dimensions.H"
#include"symm.H"
#include"formula.H"
// depository and search structures for reachability graph, TARJAN

class Statevector;

// State objects are nodes in the state graph They are linked to
// the marking vector via the contents entry
class State
{
public:
  State();
  ~State();
  static unsigned int card;
  Statevector * contents;
#ifndef MODELCHECKING
  Transition ** firelist; // Transitions to be fired
  unsigned int current; // Nr of last already fired element of firelist
	State ** succ; // successor states in graph
  State * parent; // state responsible for first generation
  unsigned int dfs,min; // TARJAN's values
#endif
#ifdef MODELCHECKING
	unsigned int nr;
	State ** witness; // Next states in witness path (per subformula)
	Transition ** witnesstransition; // transition realising the witness path
	Transition *** checkfirelist;
	State ** checkparent;
	unsigned int * checkcurrent;
	bool * value; // value of subformulas
	bool * known; // subformula already evaluated ?
	State ** tarjanstack;
	unsigned int * checkdfs, * checkmin;
	void protocol();
#endif
#ifdef COVER
	State * smaller; // points to covered state that is responsible for 
					 // w-Intro, is nil if such a state does not exist
	Place ** NewOmega; // 0-terminated array of places where 
					   // w-Intro happened at this state
#endif

};

inline State::State()
{
	int i;
#ifdef MODELCHECKING
	nr = card++;
	witness = new State * [F -> tempcard+5];
	witnesstransition = new Transition * [F -> tempcard+5];
	value = new bool [F -> card+5];
	known = new bool [F -> card+5];	
	for(i=0;i<F->tempcard;i++)
	{
		 witness[i] = (State *) 0;
		witnesstransition[i] = (Transition *) 0;
   	}
	for(i=0;i<F->card;i++)
	{
		known[i] = false;
	}
	checkfirelist = new Transition ** [F-> tempcard+5];
	checkparent = new State * [F -> tempcard+5];
	checkcurrent = new unsigned int [F -> tempcard+5];
	checkdfs = new unsigned int [F -> tempcard+5];
	checkmin = new unsigned int [F -> tempcard+5];
	tarjanstack = new State * [F -> tempcard];
	F -> evaluateatomic(this);
#endif
}

inline State::~State()
{
#ifndef MODELCHECKING
  if(firelist) delete [] firelist;
#ifdef BREADTH_FIRST
  if(succ) delete [] succ;
#endif
#endif
#ifdef MODELCHECKING
	if(witness) delete [] witness;
	if(witnesstransition) delete [] witnesstransition;
	if(checkfirelist) delete [] checkfirelist;
	if(checkparent) delete [] checkparent;
	if(checkcurrent) delete [] checkcurrent;
	if(value) delete [] value;
	if(known) delete [] known;
	if(tarjanstack) delete [] tarjanstack;
	if(checkdfs) delete [] checkdfs;
	if(checkmin) delete [] checkmin;
#endif
#ifdef COVER
	if(NewOmega) delete [] NewOmega;
#endif
}


// In Statevector, we store fragments of the marking, dependent
// on the branching structure of the decision tree
class Statevector
{
public:
  // head
  Statevector * prev;
  unsigned int length;
  State * state;
  // tail
  unsigned int * vector;

  Statevector(int);
  ~Statevector();

  unsigned int operator [] (unsigned int);
  void set(unsigned int,unsigned int);
};

inline Statevector::~Statevector()
{
	if(vector) delete [] vector;
}

inline unsigned int Statevector::operator [] (unsigned int i)
{
#ifdef CAPACITY
  return ((vector[i / MPERWORD ] >> (MSIZE * i % MPERWORD)) & MASK);
#else
  return vector[i];
#endif
}

inline void Statevector::set(unsigned int index,unsigned int value)
{
#ifdef CAPACITY
  vector[index / MPERWORD] &= ~(MASK << (MSIZE * index % MPERWORD));
  vector[index / MPERWORD] |= value << (MSIZE * index % MPERWORD);
#else
    vector[index] = value;
#endif
}

inline Statevector::Statevector(int l)
{
#ifdef CAPACITY
  vector = new unsigned int  [l / MPERWORD + 1];
#else
  vector = new unsigned int [l];
#endif
length = l;
}

class Decision
{
public:
  unsigned int PlaceNr;
  unsigned int size;
  unsigned int capacity;
  Statevector ** vector;
  unsigned int * index;
  Decision ** next;
  unsigned int * value; 

  Decision(unsigned int);
  ~Decision();
  void insert(unsigned int,Statevector *,unsigned int,Decision *);
};

inline Decision::~Decision()
{
	unsigned int i;

	for(i=0;i<size;i++)
	{
		if(next[i]) delete next[i];
		if((!index[i]) && vector[i]) delete vector[i];
	}
	if(index) delete [] index;
	if(vector) delete [] vector;
	if(value) delete [] value;
	if(next) delete [] next;
}

inline Decision::Decision(unsigned int p)
{
  PlaceNr = p;
  size = 2;
  capacity = 2;
  vector = new Statevector * [2];
  next = new Decision * [2];
  value = new unsigned int [2];
  index = new unsigned int [2];
  next[0] = (Decision *) 0;
  next[1] = (Decision *) 0;
}

inline void Decision::insert(unsigned int v, Statevector * vec, unsigned int idx,Decision *nxt)
{
  unsigned int i,pos;
  Decision ** newd;
  Statevector ** newsv;
  unsigned int * newi, * newv;
  


  if(size >= capacity)
    {
      // enlarge table
      newi = new unsigned int [2 * capacity];
      newv = new unsigned int [2 * capacity];
      newd = new Decision * [2 * capacity];
      newsv = new Statevector * [2 * capacity];
      pos = 0;
      for(i=size;i>0;i--)
	{
	  if(value[i-1] < v)
	    {
	      pos = i;
	      break;
	    }
	  newv[i] = value[i-1];
	  newi[i] = index[i-1];
	  newd[i] = next[i-1];
	  newsv[i] = vector[i-1];
	}
      newv[pos] = v;
      newi[pos] = idx;
      newd[pos] = nxt;
      newsv[i] = vec;
      for(i=0;i<pos;i++)
	{
	  newv[i] = value[i];
	  newi[i] = index[i];
	  newd[i] = next[i];
	  newsv[i] = vector[i];
	}
      delete [] value;
      delete [] index;
      delete [] next;
      delete [] vector;
      value = newv;
      index = newi;
      next = newd;
      vector = newsv;
      size += 1;
      capacity *= 2;
    }
  else
    {
      pos = 0;
      for(i=size;i>0;i--)
	{
	  if(value[i-1] < v)
	    {
	      pos = i;
	      break;
	    }
	  value[i] = value[i-1];
	  index[i] = index[i-1];
	  next[i] = next[i-1];
	  vector[i] = vector[i-1];
	}
      value[pos] = v;
      index[pos] = idx;
      next[pos] = nxt;
      vector[i] = vec;
      size += 1;
    }
}


extern Decision ** HashTable;

// The next four variables describe the situation where the last recent search
// has failed. This information is useful for a faster insertion.

extern Decision * LastDecision;
extern unsigned int LastChoice;
extern unsigned int Scapegoat;
extern Statevector * LastVector;
inline State * search_marking()
{
  unsigned int l,r,j;
  unsigned int & i = Scapegoat;
  unsigned int & m = LastChoice;
  Decision * & d = LastDecision;
  Statevector * & v = LastVector;

  // 0. Hashabelle leer -> alles klar
  v = (Statevector *) 0;
  if(!(d = HashTable[Places[0]->hash_value])) return (State *) 0;
  i = 0;
  while(d)
    {
      // 1. Interpolationssuche in Tabelle
      if(Places[i]->current_marking < d -> value[0]) return (State *) 0;
      if(Places[i]->current_marking > d -> value[d->size - 1]) return (State *) 0; 
      if(Places[i]->current_marking == d -> value[0])
	{
	  // found, no interpolation necessary
	  m = 0;
	}
      else
	{
	  if(Places[i]->current_marking == d -> value[d->size - 1])
	    {
	      // found, no interpolation necessary
	      m = d->size - 1; 
	    }
	  else
	    {
	      // Interpolation, value must be somewhere between 1 and size - 2
	      for(l=0,r=d->size - 1;l+1<r;)
		{
		  m = l + (r - l ) * (Places[i]->current_marking - d -> value[l]) / (d->value[r]-d->value[l]);
		  if(m == l) m++;
		  if(m == r) m--; // Progress sichern!
		  if(d->value[m] == Places[i]->current_marking)
		    {
		      l = r = m;
		      break;
		    }
		  else
		    {
		      if(d->value[m] < Places[i]->current_marking)
			{
			  l= m;
			}
		      else
			{
			  r = m;
			}
		    }
		}
	      if(l != r) // this means: not found!
		{
		  return (State *) 0; 
		}
	    }
	}
      // Interpolationssuche beendet, jetzt im Statevector suchen
      i++;
      v = d -> vector[m];
      for(j=d->index[m]+1;i < (d->next[m] ? d -> next[m] -> PlaceNr : Places[0]-> cnt); i++,j++)
	{
	  if((*(d -> vector[m]))[j] != Places[i]-> current_marking) return (State *) 0;
	}
      d = d -> next[m];
    } // while d
  return LastVector -> state; 
}

inline State * kr_search_marking()
{
  unsigned int l,r,j;
  unsigned int & i = Scapegoat;
  unsigned int & m = LastChoice;
  Decision * & d = LastDecision;
  Statevector * & v = LastVector;

  // 0. Hashabelle leer -> alles klar
  v = (Statevector *) 0;
  if(!(d = HashTable[Places[0]->hash_value])) return (State *) 0;
  i = 0;
  while(d)
    {
      // 1. Interpolationssuche in Tabelle
      if(kanrep[i] < d -> value[0]) return (State *) 0;
      if(kanrep[i] > d -> value[d->size - 1]) return (State *) 0; 
      if(kanrep[i] == d -> value[0])
	{
	  // found, no interpolation necessary
	  m = 0;
	}
      else
	{
	  if(kanrep[i] == d -> value[d->size - 1])
	    {
	      // found, no interpolation necessary
	      m = d->size - 1;
	    }
	  else
	    {
	      // Interpolation, value must be somewhere between 1 and size - 2
	      for(l=0,r=d->size - 1;l+1<r;)
		{
		  m = l + (r - l ) * (kanrep[i] - d -> value[l]) / (d->value[r]-d->value[l]);
		  if(m == l) m++;
		  if(m == r) m--; // Progress sichern!
		  if(d->value[m] == kanrep[i])
		    {
		      l = r = m;
		      break;
		    }
		  else
		    {
		      if(d->value[m] < kanrep[i])
			{
			  l= m;
			}
		      else
			{
			  r = m;
			}
		    }
		}
	      if(l != r) // this means: not found!
		{
		  return (State *) 0; 
		}
	    }
	}
      // Interpolationssuche beendet, jetzt im Statevector suchen
      i++;
      v = d -> vector[m];
      for(j=d->index[m]+1;i < (d->next[m] ? d -> next[m] -> PlaceNr : Places[0]-> cnt); i++,j++)
	{
	  if((*(d -> vector[m]))[j] != kanrep[i]) return (State *) 0;
	}
      d = d -> next[m];
    } // while d
  return LastVector -> state; 
}

class SearchTrace
{
public:
  unsigned int sc;
  Decision * ld;
  unsigned int lc;
  Statevector * lv;
};

extern SearchTrace * Trace;
extern unsigned int pos;
inline void trace()

{
  if((pos < CardStore) && (Scapegoat == Store[pos].argnr))
    {
      Trace[pos].sc = Scapegoat;
      Trace[pos].ld = LastDecision;
      Trace[pos].lv = LastVector;
      Trace[pos++].lc = LastChoice;
    }
}

inline State * first_symm_search_marking()
{
  unsigned int l,r,j;
  unsigned int & i = Scapegoat;
  unsigned int & m = LastChoice;
  Decision * & d = LastDecision;
  Statevector * & v = LastVector;

  // 0. Hashabelle leer -> alles klar
  v = (Statevector *) 0;
  if(!(d = HashTable[Places[0]->hash_value])) return (State *) 0;
  i = 0;
  pos = 0;
  FirstSymm();
  while(d)
    {
      trace();
      // 1. Interpolationssuche in Tabelle
      if(Places[i]->current_marking < d -> value[0]) return (State *) 0;
      if(Places[i]->current_marking > d -> value[d->size - 1]) return (State *) 0; 
      if(Places[i]->current_marking == d -> value[0])
	{
	  // found, no interpolation necessary
	  m = 0;
	}
      else
	{
	  if(Places[i]->current_marking == d -> value[d->size - 1])
	    {
	      // found, no interpolation necessary
	      m = d->size - 1;
	    }
	  else
	    {
	      // Interpolation, value must be somewhere between 1 and size - 2
	      for(l=0,r=d->size - 1;l+1<r;)
		{
		  m = l + (r - l ) * (Places[i]->current_marking - d -> value[l]) / (d->value[r]-d->value[l]);
		  if(m == l) m++;
		  if(m == r) m--; // Progress sichern!
		  if(d->value[m] == Places[i]->current_marking)
		    {
		      l = r = m;
		      break;
		    }
		  else
		    {
		      if(d->value[m] < Places[i]->current_marking)
			{
			  l= m;
			}
		      else
			{
			  r = m;
			}
		    }
		}
	      if(l != r) // this means: not found!
		{
		  return (State *) 0; 
		}
	    }
	}
      // Interpolationssuche beendet, jetzt im Statevector suchen
      i++;
      v = d -> vector[m];
      for(j=d->index[m]+1;i < (d->next[m] ? d -> next[m] -> PlaceNr : Places[0]-> cnt); i++,j++)
	{
	  trace();
	  if((*(d -> vector[m]))[j] != Places[i]-> current_marking) return (State *) 0;
	}
      d = d -> next[m];
    } // while d
  return LastVector -> state; 
}

inline State * next_symm_search_marking()
{
  unsigned int l,r,j;
  unsigned int & i = Scapegoat;
  unsigned int & m = LastChoice;
  Decision * & d = LastDecision;
  Statevector * & v = LastVector;

  d = Trace[pos].ld;
  i = Trace[pos].sc;
  m = Trace[pos].lc;
  v = Trace[pos].lv;
  if(i > d -> PlaceNr)
    {
      for(j=d->index[m]+i-d->PlaceNr;i < (d->next[m] ? d -> next[m]->PlaceNr : Places[0]->cnt);i++,j++)
	{
	  trace();
	  if((*(d->vector[m]))[j] != Places[CurrentSymm[i]]->current_marking) return (State *) 0;

	}
      d = d -> next[m];
    }
  while(d)
    {
      // 1. Interpolationssuche in Tabelle
      if(Places[CurrentSymm[i]]->current_marking < d -> value[0]) return (State *) 0;
      if(Places[CurrentSymm[i]]->current_marking > d -> value[d->size - 1]) return (State *) 0; 
      if(Places[CurrentSymm[i]]->current_marking == d -> value[0])
	{
	  // found, no interpolation necessary
	  m = 0;
	}
      else
	{
	  if(Places[CurrentSymm[i]]->current_marking == d -> value[d->size - 1])
	    {
	      // found, no interpolation necessary
	      m = d->size - 1;
	    }
	  else
	    {
	      // Interpolation, value must be somewhere between 1 and size - 2
	      for(l=0,r=d->size - 1;l+1<r;)
		{
		  m = l + (r - l ) * (Places[CurrentSymm[i]]->current_marking - d -> value[l]) / (d->value[r]-d->value[l]);
		  if(m == l) m++;
		  if(m == r) m--; // Progress sichern!
		  if(d->value[m] == Places[CurrentSymm[i]]->current_marking)
		    {
		      l = r = m;
		      break;
		    }
		  else
		    {
		      if(d->value[m] < Places[CurrentSymm[i]]->current_marking)
			{
			  l= m;
			}
		      else
			{
			  r = m;
			}
		    }
		}
	      if(l != r) // this means: not found!
		{
		  return (State *) 0; 
		}
	    }
	}
      trace();
      // Interpolationssuche beendet, jetzt im Statevector suchen
      i++;
      v = d -> vector[m];
      for(j=d->index[m]+1;i < (d->next[m] ? d -> next[m] -> PlaceNr : Places[0]-> cnt); i++,j++)
	{
	  if((*(d -> vector[m]))[j] != Places[CurrentSymm[i]]-> current_marking) return (State *) 0;
	  trace();
	}
      d = d -> next[m];
    } // while d
  return LastVector -> state; 
}

inline void print_marking()
{
  int i;
  for(i=0;i< Places[0]->cnt;i++)
    {
      if(Places[i]->current_marking)
      cout << Places[i]->name << ": " << Places[i]->current_marking << ", ";
    }
}

inline State * symm_search_marking()
{
  State * s;
  unsigned int fsc;
  unsigned int flc;
  Decision * fld;
  Statevector * flv;
  
  if(!HashTable[Places[0]->hash_value])
    {
      LastDecision = (Decision *) 0;
      return (State *) 0;
    }
  if(s = first_symm_search_marking())
    {
      return s;
    }
  fsc = Scapegoat;
  flc = LastChoice;
  fld = LastDecision;
  flv = LastVector;
  
  while((pos = NextSymm(Scapegoat)) < CardStore)
    {
      if(s = next_symm_search_marking())
	{
	  return s;
	}
    }
  Scapegoat = fsc;
  LastChoice = flc;
  LastDecision = fld;
  LastVector = flv;
  return (State *) 0;
}
      
      
  
extern unsigned int NonEmptyHash;
      
inline State * insert_marking()
{
  // Fuegt die aktuelle Markierung in die Suchstruktur ein und erzeugt das MArkierungsobjekt
  // Die Suche nach der Markierung muss vorher fehlgeschlagen sein, LastDecision, LastChoice und Scapegoat muessen 
  // unbedingt die Werte
  // vom fehlgeschlagenen Versuch haben.
  
  Statevector * sv;
  unsigned int i;
  // HashTable n    
  if(LastDecision)
    {
      // HashTable not empty
      if(Scapegoat == LastDecision -> PlaceNr)
	{
	  // In diesem Fall muss die Tabelle um einen neuen Eintrag ergaenzt werden und ein neuer
	  // Statevector angelegt
	  sv = new Statevector(Places[0]->cnt - Scapegoat);
	  for(i=Scapegoat;i < Places[0]-> cnt;i++)
	    {
	      sv -> set(i - Scapegoat,Places[i]-> current_marking);
	    }
	  LastDecision -> insert(Places[Scapegoat]->current_marking,sv,0,(Decision *) 0);
	  sv -> state = new State;
	  sv -> state -> contents = sv;
	  sv -> prev = LastVector;
	  return sv -> state;
	}
      else
	{
	  // EineTabelle muss neu angelegt werden, ein Eintrag zeigt auf die
	  // bisherige Markierung, ein anderer auf die neue
	  
	  Decision * NewDecision;
	  unsigned int oldindex,newindex;
	  NewDecision = new Decision(Scapegoat);
	  oldindex = Places[Scapegoat]-> current_marking < (*LastVector)[Scapegoat - LastDecision  -> PlaceNr + LastDecision -> index[LastChoice]] ? 1 : 0;
	  // bearbeite die Seite der alten Markierung
	  NewDecision -> value[oldindex] = (*LastVector)[Scapegoat - LastDecision -> PlaceNr + LastDecision -> index[LastChoice]];
	  NewDecision -> vector[oldindex] = LastVector;
	  NewDecision -> index[oldindex] = Scapegoat - LastDecision  -> PlaceNr + LastDecision -> index[LastChoice];
	  NewDecision -> next[oldindex] = LastDecision -> next[LastChoice];
	  LastDecision -> next[LastChoice] = NewDecision;
	  // bearbeite die Seite der neuen Markierung
	  newindex = 1 - oldindex;
	  sv = new Statevector(Places[0]->cnt - Scapegoat);
	  for(i=Scapegoat;i < Places[0]-> cnt;i++)
	    {
	      sv ->set(i - Scapegoat,Places[i]-> current_marking);
	    }
	  NewDecision -> value[newindex] = Places[Scapegoat]->current_marking;
	  NewDecision -> vector[newindex] = sv;
	  NewDecision -> index[newindex] = 0;
	  NewDecision -> next[newindex] = (Decision *) 0;
	  sv -> state = new State;
	  sv -> state -> contents = sv;
	  sv -> prev = LastVector;
	  return sv -> state;
	}
    }
  else
    {
      // Hashtabelleneintrag leer, also Einertabelle anlegen und komplette Markeirung speichern
      NonEmptyHash++;
      Decision * d;
      d = new Decision(0);
      d -> size = 1;
      d -> value[0] = Places[0]-> current_marking;
      d -> index[0] = 0;
      d -> next[0] = (Decision *) 0;
      sv = d -> vector[0] = new Statevector(Places[0] -> cnt);
      for(i=0;i< Places[0]-> cnt;i++)
	{
	  sv ->set(i,Places[i]->current_marking);
	}
      sv -> state = new State;
      sv -> state -> contents = sv;
      sv -> prev = (Statevector *) 0;
      HashTable[Places[0]->hash_value] = d; 
      return sv -> state;
    }
}
inline State * kr_insert_marking()
{
  // Fuegt die Markierung in kanrep in die Suchstruktur ein und erzeugt das MArkierungsobjekt
  // Die Suche nach der Markierung muss vorher fehlgeschlagen sein, LastDecision, LastChoice und Scapegoat muessen 
  // unbedingt die Werte
  // vom fehlgeschlagenen Versuch haben.
  
  Statevector * sv;
  unsigned int i;
  // HashTable n    
  if(LastDecision)
    {
      // HashTable not empty
      if(Scapegoat == LastDecision -> PlaceNr)
	{
	  // In diesem Fall muss die Tabelle um einen neuen Eintrag ergaenzt werden und ein neuer
	  // Statevector angelegt
	  sv = new Statevector(Places[0]->cnt - Scapegoat);
	  for(i=Scapegoat;i < Places[0]-> cnt;i++)
	    {
	      sv -> set(i - Scapegoat,kanrep[i]);
	    }
	  LastDecision -> insert(kanrep[Scapegoat],sv,0,(Decision *) 0);
	  sv -> state = new State;
	  sv -> state -> contents = sv;
	  sv -> prev = LastVector;
	  return sv -> state;
	}
      else
	{
	  // EineTabelle muss neu angelegt werden, ein Eintrag zeigt auf die
	  // bisherige Markierung, ein anderer auf die neue
	  
	  Decision * NewDecision;
	  unsigned int oldindex,newindex;
	  NewDecision = new Decision(Scapegoat);
	  oldindex = kanrep[Scapegoat] < (*LastVector)[Scapegoat - LastDecision  -> PlaceNr + LastDecision -> index[LastChoice]] ? 1 : 0;
	  // bearbeite die Seite der alten Markierung
	  NewDecision -> value[oldindex] = (*LastVector)[Scapegoat - LastDecision -> PlaceNr + LastDecision -> index[LastChoice]];
	  NewDecision -> vector[oldindex] = LastVector;
	  NewDecision -> index[oldindex] = Scapegoat - LastDecision  -> PlaceNr + LastDecision -> index[LastChoice];
	  NewDecision -> next[oldindex] = LastDecision -> next[LastChoice];
	  LastDecision -> next[LastChoice] = NewDecision;
	  // bearbeite die Seite der neuen Markierung
	  newindex = 1 - oldindex;
	  sv = new Statevector(Places[0]->cnt - Scapegoat);
	  for(i=Scapegoat;i < Places[0]-> cnt;i++)
	    {
	      sv ->set(i - Scapegoat,kanrep[i]);
	    }
	  NewDecision -> value[newindex] = kanrep[Scapegoat];
	  NewDecision -> vector[newindex] = sv;
	  NewDecision -> index[newindex] = 0;
	  NewDecision -> next[newindex] = (Decision *) 0;
	  sv -> state = new State;
	  sv -> state -> contents = sv;
	  sv -> prev = LastVector;
	  return sv -> state;
	}
    }
  else
    {
      // Hashtabelleneintrag leer, also Einertabelle anlegen und komplette Markeirung speichern
      NonEmptyHash++;
      Decision * d;
      d = new Decision(0);
      d -> size = 1;
      d -> value[0] = kanrep[0];
      d -> index[0] = 0;
      d -> next[0] = (Decision *) 0;
      sv = d -> vector[0] = new Statevector(Places[0] -> cnt);
      for(i=0;i< Places[0]-> cnt;i++)
	{
	  sv ->set(i,kanrep[i]);
	}
      sv -> state = new State;
      sv -> state -> contents = sv;
      sv -> prev = (Statevector *) 0;
      HashTable[Places[0]->hash_value] = d; 
      return sv -> state;
    }
}
  
inline State * canonical_representitive()
{
  unsigned int level, current, current_min,i;
  unsigned int * swap;

  // 2. Markierung nach kanrep austragen

  for(i=0;i<Places[0]->cnt;i++)
    {
      kanrep[i] = Places[i]->current_marking;
    }

  // 3. Sortieren auf kanrep
  for(level = 0; level < CardStore;level++)
    {
      current_min = Store[level].card;
      for(current = 0;current < Store[level].card;current++)
	{
	  for(i=Store[level].argnr;i<Places[0]->cnt;i++)
	    {
	      if((current_min < Store[level].card ?
		  kanrep[Store[level].image[current_min].vector[i-Store[level].argnr]] : kanrep[i]) 
		 != kanrep[Store[level].image[current].vector[i-Store[level].argnr]])
		{
		  break;
		}
	    }
	  if(i >= Places[0]->cnt) continue;
	  if((current_min < Store[level].card ?
	      kanrep[Store[level].image[current_min].vector[i-Store[level].argnr]] : kanrep[i]) 
	     > kanrep[Store[level].image[current].vector[i-Store[level].argnr]])
	    {
	      current_min = current;
	    }
	}
      if(current_min < Store[level].card)
	{
	  for(i=0;i<Store[level].argnr;i++)
	    {
	      kanrep1[i]=kanrep[i];
	    }
	  for(i=Store[level].argnr;i < Places[0]->cnt;i++)
	    {
	      kanrep1[i] = kanrep[Store[level].image[current_min].vector[i-Store[level].argnr]];
	    }
	  swap = kanrep;
	  kanrep = kanrep1;
	  kanrep1 = swap;
	}
    }
  // 5. suchen
  return kr_search_marking();

}
      
void RemoveGraph();      
unsigned int depth_first();
unsigned int breadth_first();

Transition ** firelist();
extern unsigned int CardFireList;
extern State * CurrentState;
int reversibility();
int home();
void statistics(unsigned int, unsigned int, unsigned int);

#ifdef EXTENDED
	extern unsigned int currentdfsnum;
#endif
#endif

















