%VBAKF_PREDICT_DIAG  Diagonal Variational Bayesian Adaptive Kalman Filter prediction step
%
% Syntax:
%   [M,P,ALPHA,BETA] = VBAKF_PREDICT_DIAG(M,P,A,Q,ALPHA,BETA,LAMBDA)
%
% Author:
%   Simo Srkk, 2006
%
% In:
%       M - Nx1 mean state estimate after prediction step
%       P - NxN state covariance after prediction step
%       A - Transition matrix of discrete model (optional, default identity)
%       Q - Process noise of discrete model     (optional, default zero)
%   ALPHA - Vector of Inv-Gamma prior parameters alpha_i of noise variance
%    BETA - Vector of Inv-Gamma prior parameter beta_i of noise variance
%  LAMBDA - Dynamic coefficient(s) (0,1]
%
% Out:
%       M - Predicted state mean
%       P - Predicted state covariance
%   ALPHA - Predicted parameters alpha
%    BETA - Predicted parameters beta
%
% Description:

function [m,P,a,b] = vbakf_predict_diag(m,P,A,Q,a,b,lambda)

  [m,P] = kf_predict(m,P,A,Q);
    
  a = lambda.*a;
  b = lambda.*b;
