%VBAKF_UPDATE_1D  1D Variational Bayesian Adaptive Kalman Filter update step
%
% Syntax:
%   [M,P,ALPHA,BETA,K,IM,IS,LH] = VBAKF_UPDATE_1D(M,P,Y,H,ALPHA,BETA,ITER)
%
% Author:
%   Simo Srkk, 2006
%
% In:
%       M - Nx1 mean state estimate after prediction step
%       P - NxN state covariance after prediction step
%       Y - Scalar measurement
%       H - 1xN Measurement matrix.
%   ALPHA - Inv-Gamma prior parameter alpha of noise variance
%    BETA - Inv-Gamma prior parameter beta of noise variance
%    ITER - Number of iterations (optional, default 2)
%
% Out:
%       M  - Updated state mean
%       P  - Updated state covariance
%   ALPHA - Updated parameter alpha
%    BETA - Updated parameter beta
%       K - Computed Kalman gain
%      MU - Mean of predictive distribution of Y
%       S - Covariance or predictive mean of Y
%      LH - Predictive probability (likelihood) of measurement.

function [m,P,a,b,K,mu,S] = vbakf_update_1d(m,P,Y,H,a,b,iter)

  if nargin < 7
    iter = [];
  end

  if isempty(iter)
    iter = 2;
  end
  
  %
  % Compute approximation by iteration
  %
  m0 = m;
  P0 = P;
  a0 = a;
  b0 = b;
  a = a0 + 0.5;
  for i=1:iter
    [m,P,K,mu,S] = kf_update(m0,P0,Y,H,b/a);
    v = Y-H*m;
    b = b0 + 0.5*v'*v + 0.5*H*P*H';
  end

  %
  % Should compute the likelihood here
  % from the correponding student T distribution
  %
