%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Demonstration of the Variational Bayesian Adaptive Kalman Filter
% with sensor network data.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Copyright (C) 2006 Simo Srkk
%
% $Id: vbakf_demo2.m,v 1.3 2007/02/06 10:33:46 ssarkka Exp $
%
% This software is distributed under the GNU General Public 
% Licence (version 2 or later); please refer to the file 
% Licence.txt, included with the software, for details.

  D = load('data10_kesa.txt');
  
  %
  % Simple brownian motion model
  %
  Y = D(:,3);
  m0 = D(1);
  P0 = 100;
  q = 1e-2;
  F = 0;
  L = 1;
  H = 1;
  lambda = 0.9;
  dt = 1;
  T = (1:length(Y))*dt;

  theta = (0.1:0.1:5);
      
  [A,Q] = lti_disc(F,L,q,dt);
  MM = zeros(size(m0,1),length(Y));
  VV = zeros(size(m0,1),length(Y));
  Q_05 = zeros(size(m0,1),length(Y));
  Q_95 = zeros(size(m0,1),length(Y));

  m = m0;
  P = P0;
  a = 1;
  b = 1;
  
  for k=1:length(Y)
    [m,P,a,b] = vbakf_predict_1d(m,P,A,Q,a,b,lambda);
    [m,P,a,b] = vbakf_update_1d(m,P,Y(k),H,a,b);

    MM(:,k) = m;
    VV(k) = b/(a-1);
      
    p = -(a+1)*log(theta) - b./theta;
    p = p - median(p);
    p = exp(p);
    p = p./sum(p);

    c = cumsum(p);
    Q_05(k) = theta(max([find(c < 0.05) 1]));
    Q_95(k) = theta(min([find(c > 0.95) length(c)]));
    
    %
    % Plot
    %
    if rem(k,50) == 0
      subplot(1,3,1);

      plot(theta,p);
      title('vbakf p(\theta)');
      
      subplot(1,3,2);
      plot(T,Y,'.',T(1:k),H*MM(:,1:k),'k-');
      title('vbakf estimate');

      subplot(1,3,3);

      plot(T(1:k),VV(1:k),'-',...
           T(1:k),Q_05(1:k),':',T(1:k),Q_95(1:k),':');
      axis([0 T(end) 0 2*max(VV)]);
      title('vbakf variance');
      legend('True','Estimated mean');
      
      drawnow;
      pause(0.01);
    end
  end

  pause;
  clf
  plot(T,VV,T,Q_05,':',T,Q_95,':')
  semilogy(T,VV,T,Q_05,':',T,Q_95,':')
  plot(T,VV,T,Q_05,':',T,Q_95,':')
  title('Kesn data, mote 10')
  xlabel('Mittausnumero'); ylabel('Varianssi');
