%IMM_ESTIMATE  Calculate mean and covariance of IMM mixture
%
% Syntax:
%   [m,C] = IMM_ESTIMATE(M,P,W)
%
% Author:
%   Simo Srkk, 2003
%
% In:
%   M - Dx1xN mean state estimates
%   P - DxDxN state covariances
%   W - 1xN vector of mode weights
%
% Out:
%   m - State estimate mean
%   C - State estimate covariance
%   
% Description:
%   Calculate mean and covariance of IMM mixture.
%   This is just a helper routine to ease the interpretation
%   of mixture Gaussian output of IMM filter.
%
% See also:
%   IMM_PREDICT, IMM_UPDATE

% History:
%   18.02.2003  The first official version.
%
% Copyright (C) 2003 Simo Srkk
%
% $Id: imm_estimate.m,v 1.1 2007/08/21 14:26:13 ssarkka Exp $
%
% This software is distributed under the GNU General Public 
% Licence (version 2 or later); please refer to the file 
% Licence.txt, included with the software, for details.

function [m,C] = imm_estimate(M,P,W)

  m = zeros(size(M,1),1);
  for i=1:size(M,2)
    m = m + W(i) * M(:,i);
  end
  C = zeros(size(M,1),size(M,1));
  for i=1:size(M,2)
    C = C + W(i) * (P(:,:,i) + (M(:,i) - m) * (M(:,i) - m)');
  end
