%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%     Interactive Multiple Model Filter demonstration II
%
%            Multiple dynamic models
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% History:
%   18.02.2003 SS  The first implementation
%
% Copyright (C) 2003 Simo Srkk
%
% $Id: imm_demo2.m,v 1.1 2007/08/21 14:26:12 ssarkka Exp $
%
% This software is distributed under the GNU General Public 
% Licence (version 2 or later); please refer to the file 
% Licence.txt, included with the software, for details.

  %
  % Create route with two turns
  % and some random perturbations.
  % Also generate measurements
  % with some noise added.
  %
  sd = 0.01;
  dt = 0.01;
  nsteps = 500;
  a = zeros(1,nsteps);
  a(1,50:100)  = pi/2/51/dt + 0.01*randn(1,51);
  a(1,200:250) = pi/2/51/dt + 0.01*randn(1,51);
  a(1,350:400) = pi/2/51/dt + 0.01*randn(1,51);
  x = [0;0;1;0];
  X = zeros(size(x,1),nsteps);
  Y = zeros(2,nsteps);
  for i=1:nsteps
    F = [0 0  1    0;...
         0 0  0    1;...
         0 0  0   a(i);...
         0 0 -a(i) 0];
    x = expm(F*dt)*x;
    X(:,i) = x;
    Y(:,i) = x(1:2) + sd*randn(2,1);
  end
  true_a = a;

  %
  % Create IMM model having
  % models for a=-3:3
  %
  a = -3:3;
  N = size(a,2);
  A = zeros(4,4,N);
  Q = zeros(4,4,N);
  M = zeros(4,N);
  P = zeros(4,4,N);
  q = 0.001;
  Qc = diag([0 0 q q]);
  M0 = [0;0;1;0];
  P0 = diag([0.1;0.1;1;1]);

  for i=1:size(a,2)
    F = [0 0 1 0;...
         0 0 0 1;...
         0 0 0 a(i);...
         0 0 -a(i) 0];
    [A(:,:,i),Q(:,:,i)] = lti_disc(F,[],Qc,dt);
    M(:,i)   = M0;
    P(:,:,i) = P0;
  end
  R = diag([sd^2 sd^2]);
  H = [1 0 0 0;...
       0 1 0 0];

  pp = 0.95;
  PIJ = pp*eye(N) + (1-pp)/2*diag(ones(N-1,1),1) +...
                    (1-pp)/2*diag(ones(N-1,1),-1);
  PIJ(1,1) = PIJ(1,1) + (1-pp)/2;
  PIJ(N,N) = PIJ(N,N) + (1-pp)/2;

  %
  % Track and animate
  %
  EST = [];
  WW = zeros(size(Y,2),N);
  W  = ones(1,N)/N;

  clf;
  for k=1:size(Y,2)
    %
    % Track with IMM
    %
    [M,P,W] = imm_predict(M,P,W,PIJ,A,Q);
    [M,P,W] = imm_update(M,P,W,Y(:,k),H,R);
    [m,C]   = imm_estimate(M,P,W);

    EST = [EST m];
    WW(k,:) = W;

%    for i=1:N
%      fprintf('%.3f ',W(i));
%    end
%    fprintf('\n');

    %
    % Animate
    %
    if rem(k,10)==1
    plot(X(1,:),X(2,:),'b--',...
         Y(1,:),Y(2,:),'r.',...
         EST(1,k),EST(2,k),'k*',...
         EST(1,:),EST(2,:),'k-');
    drawnow;
    end
  end

  %
  % Plot angular velocity estimate
  %
  est_a = zeros(1,size(Y,2));
  for i=1:size(Y,2)
    est_a(i) = sum(a.*WW(i,:));
  end

  plot(1:size(Y,2),true_a,'--',1:size(Y,2),est_a);
  legend('True','Estimated');
  title('Angular velocity');
