%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%     Interactive Multiple Model Filter demonstration I
%
%            Noise adaptive filtering
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% History:
%   18.02.2003 SS  The first implementation
%
% Copyright (C) 2003 Simo Srkk
%
% $Id: imm_demo1.m,v 1.1 2007/08/21 14:26:12 ssarkka Exp $
%
% This software is distributed under the GNU General Public 
% Licence (version 2 or later); please refer to the file 
% Licence.txt, included with the software, for details.

  %
  % Create sine function
  %
  S1 = [0.2;1.0];
  S2 = [1.0;-0.2];
  sd = 0.3;
  dt = 0.1;
  w = 1;
  T = (0:dt:20);
  X = sin(w*T);
  Y = X + sd*randn(size(X));

  %
  % Initialize KF's to values
  %
  %   x     = 0
  %   dx/dt = 0
  %
  % with great uncertainty in derivative. Use
  % noise levels 0.1 -- 0.5 as different
  % IMM models.
  %
  S = (0.1:0.01:0.5);
  R = zeros(1,1,size(S,2));
  for i=1:size(S,2)
    R(1,1,i) = S(i)^2;
  end
  N = size(R,3);
  M = repmat([0;0],[1 N]);
  P = repmat(diag([0.1 2]),[1 1 N]);
  H = repmat([1 0],[1 1 N]);
  q = 0.05;
  F = [0 1;
       0 0];
  [A,Q] = lti_disc(F,[],diag([0 q]),dt);
  PIJ = eye(N);

  %
  % Track and animate
  %
  EST = [];
  WW  = zeros(size(Y,2),N);
  W   = ones(1,N)/N;

  clf;
  for k=1:size(Y,2)
    %
    % Track with IMM
    %
    [M,P,W] = imm_predict(M,P,W,PIJ,A,Q);
    [M,P,W] = imm_update(M,P,W,Y(k),H,R);

    [m,C] = imm_estimate(M,P,W);
    EST = [EST m];

%    for i=1:N
%      fprintf('%.3f ',W(i));
%    end
%    fprintf('\n');

    %
    % Animate
    %
    if rem(k,10)==1
    plot(T,X,'b--',...
         T,Y,'ro',...
         T(k),m(1),'k*',...
         T(1:k),EST(1,:),'k-');
    drawnow;
    end
  end

  %
  % Estimated noise level
  %
  est_sd = 0;
  for i=1:N
    est_sd = est_sd + W(i) * sqrt(R(1,1,i));
  end
  fprintf('std = %-3f, est-std = %.3f\n',sd,est_sd);

  clf;
  stem(sqrt(shiftdim(R)),W);
  title('Estimated posterior of standard deviation');

