%EQ_DESIGN_ORFANIDIS Design discrete-time EQ w/ Orfanidis formulas
%
% Syntax: 
%   [b, a] = eq_design_orfanidis(fs, f, q, g_db)
%
% In:
%     fs - Sampling frequency
%      f - Center frequency
%      q - The quality factor
%   g_db - Gain in decibels
%
% Out:
%      B - 1x3 numerator filter polynomial coefficients
%      A - 1x3 denumerator filter polynomial coefficients

function [b, a, G0, G, GB, Dw] = eq_design_orfanidis(fs, f, q, g_db)

G0 = 1;
G = 10^(g_db/20);
GB = sqrt(G);
w0 = 2*pi*f/fs;

bw = 1/q;
Dw = bw*w0;

F = abs(G^2 - GB^2);
G00 = abs(G^2 - G0^2);
F00 = abs(GB^2 - G0^2);
num = G0^2 * (w0^2 - pi^2)^2 + G^2 * F00 * pi^2 * Dw^2 / F;
den = (w0^2 - pi^2)^2 + F00 * pi^2 * Dw^2 / F;
G1 = sqrt(num/den);
G01 = abs(G^2 - G0*G1);
G11 = abs(G^2 - G1^2);
F01 = abs(GB^2 - G0*G1);
F11 = abs(GB^2 - G1^2);
W2 = sqrt(G11 / G00) * tan(w0/2)^2;
DW = (1 + sqrt(F00 / F11) * W2) * tan(Dw/2);
C = F11 * DW^2 - 2 * W2 * (F01 - sqrt(F00 * F11));
D = 2 * W2 * (G01 - sqrt(G00 * G11));
A = sqrt((C + D) / F);
B = sqrt((G^2 * C + GB^2 * D) / F);
b = [(G1 + G0*W2 + B), -2*(G1 - G0*W2), (G1 - B + G0*W2)] / (1 + W2 + A);
a = [1, [-2*(1 - W2), (1 + W2 - A)] / (1 + W2 + A)];
