%EQ_DESIGN_ORFANIDIS Design discrete-time EQ w/ Orfanidis' "old" formulas
%
% Syntax: 
%   [b, a] = eq_design_bilinear(fs, f, q, g_db)
%
% In:
%     fs - Sampling frequency
%      f - Center frequency
%      q - The quality factor
%   g_db - Gain in decibels
%
% Out:
%      B - 1x3 numerator filter polynomial coefficients
%      A - 1x3 denumerator filter polynomial coefficients

function [b, a, G0, G, GB, Dw] = eq_design_bilinear(fs, f, q, g_db)

G0 = 1;
G = 10^(g_db/20);
GB = sqrt(G);
w0 = 2*pi*f/fs;

bw = 1/q;
Dw = bw*w0;

beta = sqrt((GB^2-G0^2)/(G^2-GB^2))*tan(Dw/2);

b = [(G0 + G*beta), -2*(G0 * cos(w0)), (G0 - G*beta)] / (1 + beta);
a = [1, [-2*cos(w0), (1 - beta)] / (1 + beta)];
